// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_detected_callback()" );

	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_removed_callback()" );

	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = nVideoHeight;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = bVideoIsInterleaved;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = dVideoFrameRate;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %2.3f, %d, %d, %d )", nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );
	
	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    return QCAP_RT_OK;
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)

	
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_STATIC_LIVE_WINDOW, m_statLiveWindow);
	DDX_Control(pDX, IDC_STATIC_INFO, m_strDeviceInfo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	KillTimer( 0x00000000 );

	// UNINITIALIZE DEVICE RESOURCE
	// 
	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}
	if( m_pMemoryBuffer ) {

		free( m_pMemoryBuffer );

		m_pMemoryBuffer = NULL;
	}
	if( m_hMemoryBitmap ) {

		DeleteObject( m_hMemoryBitmap );

		m_hMemoryBitmap = NULL;
	}
	if( m_hMemoryDC ) {

		DeleteDC( m_hMemoryDC );

		m_hMemoryDC = NULL;
	}
	if( m_hScreenDC ) {

		DeleteDC( m_hScreenDC );

		m_hScreenDC = NULL;
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	m_pDevice = NULL;

	m_nDeviceVideoWidth = 0;

	m_nDeviceVideoHeight = 0;

	m_bDeviceVideoIsInterleaved = FALSE;

	m_dDeviceVideoFrameRate = 0.0;

	m_nDeviceAudioChannel = 0;

	m_nDeviceAudioBitsPerSample= 0;

	m_nDeviceAudioSampleFrequency = 0;

	m_hScreenDC = NULL;

	m_hMemoryDC = NULL;

	m_hMemoryBitmap = NULL;

	m_pMemoryBuffer = NULL;

	m_ptArrowStartPos = CPoint( 0, 0 );

	m_ptArrowStopPos = CPoint( 0, 0 );

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "CAMERA", 0, m_statLiveWindow.m_hWnd, &m_pDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

	QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_RUN( m_pDevice );


	//GDI+

	{	CRect rect;
		
		m_statLiveWindow.GetClientRect( &rect );

		m_hScreenDC = CreateDC( "DISPLAY", NULL, NULL, NULL );

		m_hMemoryDC = CreateCompatibleDC( m_hScreenDC );

		m_hMemoryBitmap = CreateCompatibleBitmap( m_hScreenDC, rect.Width(), rect.Height() );

		SelectObject( m_hMemoryDC, m_hMemoryBitmap );
		
		GetObject( m_hMemoryBitmap, sizeof(BITMAP), &m_sMemoryBitmap );

		m_pMemoryBuffer = (BYTE *)malloc( m_sMemoryBitmap.bmWidth * m_sMemoryBitmap.bmHeight * 4 );
	}
	SetTimer( 0x00000000, 1, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
/*		static ULONG counts = 0;

			Graphics graphics( m_hMemoryDC );

			graphics.SetSmoothingMode( SmoothingModeAntiAlias );

			graphics.SetInterpolationMode( InterpolationModeHighQualityBicubic );

			// DRAW COOL STRING
			//
			{	FontFamily o_font_family( L"Arial" );

				wchar_t pszbuf[] = L"Yuan High-Tech";

				GraphicsPath o_path;

				o_path.AddString( pszbuf, -1, &o_font_family, FontStyleRegular, 100, Point( 10, 10 ), NULL );

				for( ULONG i = 0 ; i < 8 ; i++ ) {

					Pen o_pen( Color( (BYTE)(255 / (i + 1)), 0, 0, 255 ), i + 1.0f );

					o_pen.SetLineJoin( LineJoinRound );

					graphics.DrawPath( &o_pen, &o_path );
				}
				SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );

				graphics.FillPath( &o_solid_brush_white, &o_path );
			}
			GetBitmapBits( m_hMemoryBitmap, (m_sMemoryBitmap.bmWidth * m_sMemoryBitmap.bmHeight * 4), m_pMemoryBuffer );

			QCAP_SET_OSD_BUFFER( m_pDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_ARGB32, m_pMemoryBuffer, m_sMemoryBitmap.bmWidth, m_sMemoryBitmap.bmHeight, m_sMemoryBitmap.bmWidth * 4, 255);
		*/
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CAnimationFactoryDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x000000000 ) {

		KillTimer( 0x00000000 );

		if( m_nDeviceVideoWidth == 0 ||

			m_nDeviceVideoHeight == 0 ) {

			m_strDeviceInfo.SetWindowText( "INFO: ..." );
		}
		else {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "INFO: %d x %d%c @ %2.3f, %d x %d x %d", m_nDeviceVideoWidth, m_nDeviceVideoHeight, m_bDeviceVideoIsInterleaved ? 'i' : 'p', m_dDeviceVideoFrameRate, m_nDeviceAudioChannel, m_nDeviceAudioBitsPerSample, m_nDeviceAudioSampleFrequency );

			m_strDeviceInfo.SetWindowText( psz );
		}
	}
	CDialog::OnTimer(nIDEvent);
}

void CAnimationFactoryDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	SetCapture();

	CPoint point_parent( 0, 0 );

	CRect rect;

	ClientToScreen( &point_parent );

	m_statLiveWindow.GetWindowRect( &rect );

	m_ptArrowStartPos = CPoint( point.x - (rect.left - point_parent.x), point.y - (rect.top - point_parent.y) );

	m_ptArrowStopPos = m_ptArrowStartPos;

	CDialog::OnLButtonDown(nFlags, point);
}

void CAnimationFactoryDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CPoint point_parent( 0, 0 );

	CRect rect;

	ClientToScreen( &point_parent );

	m_statLiveWindow.GetWindowRect( &rect );

	m_ptArrowStopPos = CPoint( point.x - (rect.left - point_parent.x), point.y - (rect.top - point_parent.y) );

	m_sArrowArray.Add( m_ptArrowStartPos );
		
	m_sArrowArray.Add( m_ptArrowStopPos );

	ReleaseCapture();

	CDialog::OnLButtonUp(nFlags, point);
}

void CAnimationFactoryDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	if( GetCapture() != NULL ) {

		CPoint point_parent( 0, 0 );

		CRect rect;

		ClientToScreen( &point_parent );

		m_statLiveWindow.GetWindowRect( &rect );

		m_ptArrowStopPos = CPoint( point.x - (rect.left - point_parent.x), point.y - (rect.top - point_parent.y) );

		Graphics graphics( m_hMemoryDC );

		graphics.SetSmoothingMode( SmoothingModeAntiAlias );

		graphics.SetInterpolationMode( InterpolationModeHighQualityBicubic );

		graphics.Clear( Color( 0, 0, 0, 0 ) );

		Pen o_pen( Color( 255, 0, 255, 0 ), 5.0f );

		o_pen.SetStartCap( LineCapRoundAnchor );

		o_pen.SetEndCap( LineCapArrowAnchor );

		o_pen.SetDashCap( DashCapRound );

		o_pen.SetDashStyle( DashStyleDash );

		for( LONG i = 0 ; i < m_sArrowArray.GetSize() ; i += 2 ) {

			graphics.DrawLine( &o_pen, m_sArrowArray[ i ].x, m_sArrowArray[ i ].y, m_sArrowArray[ i + 1 ].x, m_sArrowArray[ i + 1 ].y );
		}
		graphics.DrawLine( &o_pen, m_ptArrowStartPos.x, m_ptArrowStartPos.y, m_ptArrowStopPos.x, m_ptArrowStopPos.y );

		GetBitmapBits( m_hMemoryBitmap, (m_sMemoryBitmap.bmWidth * m_sMemoryBitmap.bmHeight * 4), m_pMemoryBuffer );

		QCAP_SET_OSD_BUFFER( m_pDevice, 0, 0, 0, m_nDeviceVideoWidth, m_nDeviceVideoHeight, QCAP_COLORSPACE_TYEP_ARGB32, m_pMemoryBuffer, m_sMemoryBitmap.bmWidth, m_sMemoryBitmap.bmHeight, m_sMemoryBitmap.bmWidth * 4, 255);
	}
	CDialog::OnMouseMove(nFlags, point);
}
